import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/cash_in/cash_in_controller.dart';
import 'package:viserpay_agent/data/repo/cash_in/cash_in_repo.dart';
import 'package:viserpay_agent/data/services/api_service.dart';
import 'package:viserpay_agent/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_agent/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_agent/view/screens/money_in/widget/money_in_form.dart';

class CashInScreen extends StatefulWidget {
  const CashInScreen({super.key});

  @override
  State<CashInScreen> createState() => _CashInScreenState();
}

class _CashInScreenState extends State<CashInScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(CashInRepo(apiClient: Get.find()));
    final controller = Get.put(CashInController(cashInRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CashInController>(
        builder: (controller) => Scaffold(
              backgroundColor: MyColor.colorWhite,
              appBar: CustomAppBar(
                isShowBackBtn: true,
                title: MyStrings.cashIn.tr,
                isTitleCenter: true,
                bgColor: MyColor.getAppBarColor(),
              ),
              body: controller.isLoading
                  ? const CustomLoader()
                  : const SingleChildScrollView(
                      padding: Dimensions.screenPaddingHV,
                      child: CashInForm(),
                    ),
            ));
  }
}
